/*
 * Decompiled with CFR 0.152.
 */
package org.discordbot;

import java.security.GeneralSecurityException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.discordbot.Content;
import org.discordbot.DataConverter;
import org.discordbot.JsonUtil;
import org.discordbot.Player;
import org.discordbot.SheetsService;

public class App {
    public static ArrayList<Content> contentArrayList;
    private static final String GM_ID = "1256616828025835664";
    private static final String ADMIN_ID = "1263479088018882604";

    public static int countRecentContents(ArrayList<Content> contents) {
        LocalDateTime now = LocalDateTime.now();
        int count = 0;
        if (contents == null || contents.isEmpty()) {
            return 0;
        }
        for (Content content : contents) {
            LocalDateTime contentTime = content.getTime();
            if (contentTime == null || ChronoUnit.DAYS.between(contentTime, now) > 7L) continue;
            ++count;
        }
        return count;
    }

    public static void exportDataToSheets() throws GeneralSecurityException {
        Map<String, Player> players = JsonUtil.readPlayers();
        ArrayList<Content> contents = JsonUtil.readContents();
        List<List<Object>> playerData = DataConverter.convertPlayersToSheetFormat(players);
        List<List<Object>> contentData = DataConverter.convertContentsToSheetFormat(contents);
        SheetsService.writeDataToSheet(playerData, "Players");
        SheetsService.writeDataToSheet(contentData, "Contents");
    }

    public static String[] getVoiceChannelMemberIds(User user) {
        Member member = null;
        for (Guild guild : user.getJDA().getGuilds()) {
            Member guildMember = guild.getMember(user);
            if (guildMember == null) continue;
            member = guildMember;
            break;
        }
        if (member == null) {
            return new String[0];
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState == null || voiceState.getChannel() == null) {
            return new String[0];
        }
        VoiceChannel voiceChannel = (VoiceChannel)((Object)voiceState.getChannel());
        List<Member> members = voiceChannel.getMembers();
        return (String[])members.stream().map(m3 -> "<@" + m3.getUser().getId() + ">").toArray(String[]::new);
    }

    public static String messageReceived(MessageReceivedEvent event) {
        String message = event.getMessage().getContentRaw();
        if (message.startsWith("!attendance ")) {
            String playerId;
            int i;
            if ((message = message.replace("!attendance ", "")).isBlank()) {
                return "Please enter a name for the content";
            }
            Map<String, Player> players = JsonUtil.readPlayers();
            ArrayList<Content> contents = JsonUtil.readContents();
            if (players == null) {
                players = new HashMap<String, Player>();
            }
            if (contents == null) {
                contents = new ArrayList();
            }
            contentArrayList = contents;
            Content tempContent = new Content(message, event.getMessage().getTimeCreated().format(DateTimeFormatter.ofPattern("HH:mm dd/MM/yyyy")), event.getAuthor().getId());
            String[] parts = App.getVoiceChannelMemberIds(event.getAuthor());
            if (parts == null || parts.length == 0) {
                return "No voice chat found";
            }
            for (i = 0; i < parts.length; ++i) {
                playerId = parts[i].trim();
                tempContent.addPlayer(playerId);
            }
            for (i = 0; i < parts.length; ++i) {
                playerId = parts[i].trim();
                Player player = players.get(playerId);
                if (player != null) {
                    player.addContent(tempContent);
                    continue;
                }
                Player newPlayer = new Player(playerId);
                newPlayer.addContent(tempContent);
                players.put(playerId, newPlayer);
            }
            tempContent.updatePlayerNames();
            contents.add(tempContent);
            JsonUtil.writeData(players, contents);
            try {
                App.exportDataToSheets();
            }
            catch (Exception e) {
                StackTraceElement element = e.getStackTrace()[0];
                int lineNumber = element.getLineNumber();
                String className = element.getClassName();
                String methodName = element.getMethodName();
                return "Something went wrong, please check your format, otherwise message a GM.\nError Type: " + e.getClass() + "\nOccurred in: " + className + "." + methodName + " at line: " + lineNumber;
            }
            return "Successfully added content \"" + tempContent.getName() + "\".";
        }
        if (message.startsWith("!playerinfo ")) {
            if ((message = message.replace("!playerinfo ", "")).isBlank()) {
                return "Please enter a name for information about the player";
            }
            Map<String, Player> players = JsonUtil.readPlayers();
            ArrayList<Content> contents = JsonUtil.readContents();
            Player player = players.get(message.trim());
            if (player == null) {
                return "Player not found.";
            }
            String output = "Info about player " + player.getPlayerID() + ":\nPlayer participated in " + player.getContentsParticipated().size() + "/" + contents.size() + " contents.\nPlayer participated in " + App.countRecentContents(player.getContentsParticipated()) + "/" + App.countRecentContents(contents) + " contents in the last 7 days.";
            return output;
        }
        if (message.startsWith("!deleteplayer ")) {
            message = message.replace("!deleteplayer ", "");
            boolean isAdmin = event.getMember().getRoles().stream().anyMatch(role -> role.getId().equals(ADMIN_ID) || role.getId().equals(GM_ID));
            if (!isAdmin) {
                return "You do not have permission to use this command.";
            }
            if (message.isBlank()) {
                return "Please enter the name of the player you wish to delete";
            }
            Map<String, Player> players = JsonUtil.readPlayers();
            ArrayList<Content> contents = JsonUtil.readContents();
            Player player = players.get(message.trim());
            if (player == null) {
                return "Player not found.";
            }
            players.remove(message.trim());
            JsonUtil.writeData(players, contents);
            return "Succesfully deleted " + player.getPlayerID() + " from the database.";
        }
        if (message.startsWith("!content ")) {
            String playerId;
            int i;
            if ((message = message.replace("!content ", "")).isBlank()) {
                return "Please check the format for !content";
            }
            Map<String, Player> players = JsonUtil.readPlayers();
            ArrayList<Content> contents = JsonUtil.readContents();
            if (players == null) {
                players = new HashMap<String, Player>();
            }
            if (contents == null) {
                contents = new ArrayList();
            }
            contentArrayList = contents;
            String[] options = message.split(";");
            if (options.length != 4) {
                return "Please check the format for !content";
            }
            Content tempContent = new Content(options[0], options[1], options[2].trim());
            String[] parts = options[3].split(" ");
            Object output = "";
            for (i = 0; i < parts.length; ++i) {
                playerId = parts[i].trim();
                if (players.containsKey(playerId)) {
                    tempContent.addPlayer(playerId);
                    continue;
                }
                if (playerId.isBlank()) continue;
                output = (String)output + "\nPlayer " + playerId + " did not get added to the content.";
            }
            for (i = 0; i < parts.length; ++i) {
                playerId = parts[i].trim();
                if (!players.containsKey(playerId)) continue;
                players.get(playerId).addContent(tempContent);
            }
            tempContent.updatePlayerNames(players);
            contents.add(tempContent);
            JsonUtil.writeData(players, contents);
            try {
                App.exportDataToSheets();
            }
            catch (Exception e) {
                StackTraceElement element = e.getStackTrace()[0];
                int lineNumber = element.getLineNumber();
                String className = element.getClassName();
                String methodName = element.getMethodName();
                return "Something went wrong, please check your format, otherwise message a GM.\nError Type: " + e.getClass() + "\nOccurred in: " + className + "." + methodName + " at line: " + lineNumber;
            }
            return "Successfully added content \"" + tempContent.getName() + "\"." + (String)output;
        }
        if (message.startsWith("!delcontent")) {
            boolean isAdmin = event.getMember().getRoles().stream().anyMatch(role -> role.getId().equals(ADMIN_ID) || role.getId().equals(GM_ID));
            if (!isAdmin && !event.getMember().getId().equals("465126844585476096")) {
                return "You do not have permission to delete content.";
            }
            return App.deleteLastContent();
        }
        if (message.equalsIgnoreCase("!update")) {
            App.update();
            return "Players' contents updated and spreadsheet refreshed.";
        }
        return null;
    }

    public static String deleteLastContent() {
        ArrayList<Content> contents = JsonUtil.readContents();
        Map<String, Player> players = JsonUtil.readPlayers();
        if (contents == null || contents.isEmpty()) {
            return "No content found to delete.";
        }
        Content lastContent = contents.get(contents.size() - 1);
        contents.remove(contents.size() - 1);
        for (String playerId : lastContent.getParticipantIDS()) {
            Player player = players.get(playerId);
            if (player == null) continue;
            player.getContentsParticipated().remove(lastContent);
            if (!player.getContentsParticipated().isEmpty()) continue;
            players.remove(playerId);
        }
        JsonUtil.writeData(players, contents);
        try {
            App.exportDataToSheets();
        }
        catch (Exception e) {
            StackTraceElement element = e.getStackTrace()[0];
            int lineNumber = element.getLineNumber();
            String className = element.getClassName();
            String methodName = element.getMethodName();
            return "Something went wrong while deleting content.\nError Type: " + e.getClass() + "\nOccurred in: " + className + "." + methodName + " at line: " + lineNumber;
        }
        return "Successfully deleted the last content: \"" + lastContent.getName() + "\" and cleaned up players with no content.";
    }

    public static void update() {
        ArrayList<Content> globalContents = JsonUtil.readContents();
        Map<String, Player> players = JsonUtil.readPlayers();
        for (Player player : players.values()) {
            ArrayList<Content> playerContents = player.getContentsParticipated();
            playerContents.removeIf(content -> !globalContents.contains(content));
        }
        JsonUtil.writePlayers(players);
        SheetsService.writeDataToSheet(DataConverter.convertPlayersToSheetFormat(players), "Players");
        SheetsService.writeDataToSheet(DataConverter.convertContentsToSheetFormat(globalContents), "Contents");
        System.out.println("Update complete: invalid contents removed from players, and the sheet has been updated.");
    }
}

