/*
 * Decompiled with CFR 0.152.
 */
package org.discordbot;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.discordbot.App;
import org.discordbot.Content;
import org.discordbot.Player;
import org.json.JSONObject;

public class DataConverter {
    public static List<List<Object>> convertPlayersToSheetFormat(Map<String, Player> players) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        List<String> header = List.of("Player", "Contents Participated This Week", "Contents Participated", "List Of Contents");
        data.add(header);
        try {
            List<Integer> header2 = List.of("Total:", Integer.valueOf(App.countRecentContents(App.contentArrayList)), Integer.valueOf(App.contentArrayList.size()));
            data.add(header2);
        }
        catch (Exception e) {
            try {
                List<Integer> header2 = List.of("Total:", Integer.valueOf(0), Integer.valueOf(App.contentArrayList.size()));
                data.add(header2);
            }
            catch (Exception e2) {
                List<Integer> header2 = List.of("Total:", Integer.valueOf(0), Integer.valueOf(0));
                data.add(header2);
            }
        }
        for (Player player : players.values()) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(player.getPlayerName());
            row.add(App.countRecentContents(player.getContentsParticipated()));
            row.add(player.getContentsParticipated().size());
            row.add(player.getContentsParticipated().stream().map(Content::getName).reduce((a, b) -> a + ", " + b).orElse("No Content"));
            data.add(row);
        }
        return data;
    }

    public static List<List<Object>> convertContentsToSheetFormat(ArrayList<Content> contents) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        List<String> header = List.of("Type", "Time", "Caller", "Participants");
        data.add(header);
        for (Content content : contents) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(content.getName());
            row.add(content.getTime().format(DateTimeFormatter.ofPattern("HH'UTC' dd/MM/yy")));
            row.add(content.getCaller());
            row.add(String.join((CharSequence)", ", content.getParticipantNames()));
            data.add(row);
        }
        return data;
    }

    public static String getDiscordUsername(String discordID) {
        discordID = discordID.replaceAll("[<>@!]", "");
        String apiUrl = "https://discord.com/api/v10/users/" + discordID;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Bot MTI3ODg2ODAyMDg5ODI5OTkwNQ.Gt16Fa.8n2HhlrDt4MgmgeKtoNp66AM6851EDTLyFvx2g");
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            reader.close();
            JSONObject jsonResponse = new JSONObject(result.toString());
            Thread.sleep(10L);
            return jsonResponse.getString("username");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown user";
        }
    }
}

