/*
 * Decompiled with CFR 0.152.
 */
package org.discordbot;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.discordbot.Content;
import org.discordbot.Player;

public class JsonUtil {
    private static final String PLAYERS_FILE = "players.json";
    private static final String CONTENTS_FILE = "contents.json";
    private static final Gson gson = new Gson();

    public static Map<String, Player> readPlayers() {
        Map map;
        FileReader reader = new FileReader(PLAYERS_FILE);
        try {
            Type type = new TypeToken<Map<String, Player>>(){}.getType();
            map = (Map)gson.fromJson((Reader)reader, type);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new HashMap<String, Player>();
            }
        }
        reader.close();
        return map;
    }

    public static ArrayList<Content> readContents() {
        ArrayList arrayList;
        FileReader reader = new FileReader(CONTENTS_FILE);
        try {
            Type type = new TypeToken<ArrayList<Content>>(){}.getType();
            arrayList = (ArrayList)gson.fromJson((Reader)reader, type);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new ArrayList<Content>();
            }
        }
        reader.close();
        return arrayList;
    }

    public static void writeData(Map<String, Player> players, ArrayList<Content> contents) {
        JsonUtil.writePlayers(players);
        JsonUtil.writeContents(contents);
    }

    public static void writePlayers(Map<String, Player> players) {
        try (FileWriter writer = new FileWriter(PLAYERS_FILE);){
            gson.toJson(players, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeContents(ArrayList<Content> contents) {
        try (FileWriter writer = new FileWriter(CONTENTS_FILE);){
            gson.toJson(contents, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

