/*
 * Decompiled with CFR 0.152.
 */
package org.discordbot;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.discordbot.DataConverter;
import org.discordbot.Player;

public class Content {
    private String name;
    private String time;
    private String caller;
    private ArrayList<String> participantIDS = new ArrayList();
    private ArrayList<String> participantNames = new ArrayList();

    public Content() {
    }

    public Content(String name, String time, String callerID) {
        this.name = name;
        this.time = time;
        this.caller = DataConverter.getDiscordUsername(callerID);
    }

    public void addPlayer(String PlayerID) {
        this.participantIDS.add(PlayerID);
    }

    public String getCaller() {
        return this.caller;
    }

    public LocalDateTime getTime() {
        try {
            DateTimeFormatter pattern1 = DateTimeFormatter.ofPattern("H d/M/yyyy");
            DateTimeFormatter pattern2 = DateTimeFormatter.ofPattern("HH d/M/yyyy");
            DateTimeFormatter pattern3 = DateTimeFormatter.ofPattern("HH:mm dd/MM/yyyy");
            DateTimeFormatter pattern4 = DateTimeFormatter.ofPattern("H:m d/M/yyyy");
            return Content.parseDateTime(this.time, pattern1, pattern2, pattern3, pattern4);
        }
        catch (Exception e) {
            return LocalDateTime.MIN;
        }
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getParticipantIDS() {
        return this.participantIDS;
    }

    private static LocalDateTime parseDateTime(String dateString, DateTimeFormatter ... patterns) {
        for (DateTimeFormatter pattern : patterns) {
            try {
                return LocalDateTime.parse(dateString, pattern);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Date string does not match any known pattern: " + dateString);
    }

    public void updatePlayerNames() {
        ArrayList<String> participantNames = new ArrayList<String>();
        for (String participantID : this.participantIDS) {
            String username = DataConverter.getDiscordUsername(participantID);
            if (username == null) continue;
            participantNames.add(username);
        }
        this.participantNames = participantNames;
    }

    public void updatePlayerNames(Map<String, Player> players) {
        ArrayList<String> participantNames = new ArrayList<String>();
        for (String participantID : this.participantIDS) {
            String username = players.get(participantID).getPlayerName();
            if (username == null) continue;
            participantNames.add(username);
        }
        this.participantNames = participantNames;
    }

    public ArrayList<String> getParticipantNames() {
        return this.participantNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Content content = (Content)obj;
        return this.name.equals(content.name) && this.time.equals(content.time) && this.caller.equals(content.caller);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.time, this.caller);
    }
}

