/*
 * Decompiled with CFR 0.152.
 */
package org.discordbot;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ClearValuesRequest;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.List;

public class SheetsService {
    private static Sheets sheetsService;
    private static final String APPLICATION_NAME = "WHY BOT";
    private static final String SPREADSHEET_ID = "1R1-YZFmf1M-gZx661yd9eUv9cD3kqglee3TckABnKlo";
    private static final JsonFactory JSON_FACTORY;

    public static Sheets getSheetsService() throws IOException, GeneralSecurityException {
        if (sheetsService == null) {
            FileInputStream serviceAccountStream = new FileInputStream("why-bot-434116-d199ee47275a.json");
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)serviceAccountStream).createScoped((Collection)Lists.newArrayList((Object[])new String[]{"https://www.googleapis.com/auth/spreadsheets"}));
            sheetsService = new Sheets.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName(APPLICATION_NAME).build();
        }
        return sheetsService;
    }

    public static void writeDataToSheet(List<List<Object>> data, String sheetName) {
        try {
            Sheets sheetsService = SheetsService.getSheetsService();
            ClearValuesRequest requestBody = new ClearValuesRequest();
            String sheetRange = sheetName + "!A:Z";
            sheetsService.spreadsheets().values().clear(SPREADSHEET_ID, sheetRange, requestBody).execute();
            ValueRange body = new ValueRange().setValues(data);
            sheetsService.spreadsheets().values().update(SPREADSHEET_ID, sheetName + "!A1", body).setValueInputOption("RAW").execute();
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    static {
        JSON_FACTORY = GsonFactory.getDefaultInstance();
    }
}

