package org.discordbot;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class Content {
    private String name;
    private String time;
    private String caller;
    private ArrayList<String> participantIDS = new ArrayList<>();
    private ArrayList<String> participantNames = new ArrayList<>();

    public Content() {
    }

    public Content(String name, String time, String callerID) {
        this.name = name;
        this.time = time;
        this.caller = DataConverter.getDiscordUsername(callerID);
    }

    public void addPlayer(String PlayerID){
        participantIDS.add(PlayerID);
    }
    public String getCaller(){
        return caller;
    }
    public LocalDateTime getTime() {
        try {
            DateTimeFormatter pattern1 = DateTimeFormatter.ofPattern("H d/M/yyyy");
            DateTimeFormatter pattern2 = DateTimeFormatter.ofPattern("HH d/M/yyyy");
            DateTimeFormatter pattern3 = DateTimeFormatter.ofPattern("HH:mm dd/MM/yyyy");
            DateTimeFormatter pattern4 = DateTimeFormatter.ofPattern("H:m d/M/yyyy");
            return parseDateTime(time, pattern1, pattern2, pattern3, pattern4);
        } catch (Exception e) {
            return LocalDateTime.MIN;
        }
    }
    public String getName(){
        return name;
    }
    public ArrayList<String> getParticipantIDS(){
        return participantIDS;
    }
    private static LocalDateTime parseDateTime(String dateString, DateTimeFormatter... patterns) {
        for (DateTimeFormatter pattern : patterns) {
            try {
                return LocalDateTime.parse(dateString, pattern);
            } catch (DateTimeParseException e) {}
        }
        throw new IllegalArgumentException("Date string does not match any known pattern: " + dateString);
    }

    public void updatePlayerNames() {
        ArrayList<String> participantNames = new ArrayList<>();
        for (String participantID : participantIDS) {
            String username = DataConverter.getDiscordUsername(participantID);
            if (username != null) {
                participantNames.add(username);
            }
        }
        this.participantNames = participantNames;
    }

    public void updatePlayerNames(Map<String, Player> players) {
        ArrayList<String> participantNames = new ArrayList<>();
        for (String participantID : participantIDS) {
            String username = players.get(participantID).getPlayerName();
            if (username != null) {
                participantNames.add(username);
            }
        }
        this.participantNames = participantNames;
    }

    public ArrayList<String> getParticipantNames(){
        return participantNames;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;

        Content content = (Content) obj;
        return this.name.equals(content.name) && this.time.equals(content.time) && this.caller.equals(content.caller);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, time, caller);
    }
}
