package org.discordbot;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static org.discordbot.App.countRecentContents;

public class DataConverter {

    public static List<List<Object>> convertPlayersToSheetFormat(Map<String, Player> players) {
        List<List<Object>> data = new ArrayList<>();

        // Add header row
        List<Object> header = List.of("Player", "Contents Participated This Week","Contents Participated", "List Of Contents");
        data.add(header);
        try {
            List<Object> header2 = List.of("Total:", countRecentContents(App.contentArrayList), App.contentArrayList.size());
            data.add(header2);
        } catch (Exception e) {
            try {
                List<Object> header2 = List.of("Total:", 0, App.contentArrayList.size());
                data.add(header2);
            } catch(Exception e2){
                List<Object> header2 = List.of("Total:", 0, 0);
                data.add(header2);
            }
        }

        // Add player data
        for (Player player : players.values()) {
            List<Object> row = new ArrayList<>();
            row.add(player.getPlayerName());
            row.add(countRecentContents(player.getContentsParticipated()));
            row.add(player.getContentsParticipated().size());
            row.add(player.getContentsParticipated().stream()
                    .map(Content::getName)
                    .reduce((a, b) -> a + ", " + b)
                    .orElse("No Content"));
            data.add(row);
        }

        return data;
    }

    public static List<List<Object>> convertContentsToSheetFormat(ArrayList<Content> contents) {
        List<List<Object>> data = new ArrayList<>();

        // Add header row
        List<Object> header = List.of("Type", "Time", "Caller", "Participants");
        data.add(header);

        // Add content data
        for (Content content : contents) {
            List<Object> row = new ArrayList<>();
            row.add(content.getName());
            row.add(content.getTime().format(DateTimeFormatter.ofPattern("HH'UTC' dd/MM/yy")));
            row.add(content.getCaller());
            row.add(String.join(", ", content.getParticipantNames()));
            data.add(row);
        }

        return data;
    }

    public static String getDiscordUsername(String discordID) {
        discordID = discordID.replaceAll("[<>@!]", "");

        String apiUrl = "https://discord.com/api/v10/users/" + discordID;
        StringBuilder result = new StringBuilder();

        try {
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Bot " + Main.BOT_TOKEN);

            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            reader.close();

            JSONObject jsonResponse = new JSONObject(result.toString());
            Thread.sleep(10);
            return jsonResponse.getString("username");
        } catch (Exception e) {
            e.printStackTrace();
            return "Unknown user";
        }
    }
}
