package org.discordbot;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JsonUtil {
    private static final String PLAYERS_FILE = "players.json";
    private static final String CONTENTS_FILE = "contents.json";
    private static final Gson gson = new Gson();

    public static Map<String, Player> readPlayers() {
        try (FileReader reader = new FileReader(PLAYERS_FILE)) {
            Type type = new TypeToken<Map<String, Player>>() {}.getType();
            return gson.fromJson(reader, type);
        } catch (IOException e) {
            e.printStackTrace();
            return new HashMap<>();
        }
    }

    public static ArrayList<Content> readContents() {
        try (FileReader reader = new FileReader(CONTENTS_FILE)) {
            Type type = new TypeToken<ArrayList<Content>>() {}.getType();
            return gson.fromJson(reader, type);
        } catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }

    public static void writeData(Map<String, Player> players, ArrayList<Content> contents) {
        writePlayers(players);
        writeContents(contents);
    }

    public static void writePlayers(Map<String, Player> players) {
        try (FileWriter writer = new FileWriter(PLAYERS_FILE)) {
            gson.toJson(players, writer);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeContents(ArrayList<Content> contents) {
        try (FileWriter writer = new FileWriter(CONTENTS_FILE)) {
            gson.toJson(contents, writer);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
