package org.discordbot;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ClearValuesRequest;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.Lists;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;

public class SheetsService {
    private static Sheets sheetsService;
    private static final String APPLICATION_NAME = "WHY BOT";
    private static final String SPREADSHEET_ID = "1R1-YZFmf1M-gZx661yd9eUv9cD3kqglee3TckABnKlo";
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();

    public static Sheets getSheetsService() throws IOException, GeneralSecurityException {
        if (sheetsService == null) {
            FileInputStream serviceAccountStream = new FileInputStream("why-bot-434116-d199ee47275a.json");
            GoogleCredentials credentials = GoogleCredentials.fromStream(serviceAccountStream)
                    .createScoped(Lists.newArrayList("https://www.googleapis.com/auth/spreadsheets"));

            sheetsService = new Sheets.Builder(GoogleNetHttpTransport.newTrustedTransport(),
                    JSON_FACTORY,
                    new HttpCredentialsAdapter(credentials))
                    .setApplicationName(APPLICATION_NAME)
                    .build();
        }
        return sheetsService;
    }

    public static void writeDataToSheet(List<List<Object>> data, String sheetName) {
        try {
            Sheets sheetsService = getSheetsService();

            // Step 1: Clear all data from the specified sheet
            ClearValuesRequest requestBody = new ClearValuesRequest();
            String sheetRange = sheetName + "!A:Z";  // This clears all data from column A to Z
            sheetsService.spreadsheets().values().clear(SPREADSHEET_ID, sheetRange, requestBody).execute();

            // Step 2: Write the new data to the specified range (starting from A1 or another range)
            ValueRange body = new ValueRange().setValues(data);
            sheetsService.spreadsheets().values()
                    .update(SPREADSHEET_ID, sheetName + "!A1", body)  // Writing from A1 downward
                    .setValueInputOption("RAW")
                    .execute();
        } catch (IOException | GeneralSecurityException e) {
            e.printStackTrace(); // Print error details to console
        }
    }

}
