import pandas as pd
import matplotlib.pyplot as plt
import os

csv_path = "numbers.csv"

if not os.path.exists(csv_path):
    raise FileNotFoundError(f"CSV file not found at: {csv_path}")

# Load the CSV
df = pd.read_csv(csv_path)

# Print the first few rows and column names to debug
print("Columns found:", df.columns.tolist())
print(df.head())

# Try to access the correct column (try by name or fallback to last column)
if "generated number" in df.columns:
    numbers = df["generated number"]
else:
    numbers = df.iloc[:, -1]  # fallback to last column

# Drop NaNs (if any)
numbers = numbers.dropna()

# Make sure it's all integers
numbers = numbers.astype(int)

# Frequency count
frequency = numbers.value_counts().sort_index()

if frequency.empty:
    print("No digits found to plot.")
else:
    print("Frequency of each digit (0–9):")
    print(frequency)

    # Plotting
    plt.figure(figsize=(8, 5))
    frequency.plot(kind='bar', color='skyblue', edgecolor='black')
    plt.title("Digit Frequency in 'Generated Number' Column")
    plt.xlabel("Digit")
    plt.ylabel("Frequency")
    plt.xticks(rotation=0)
    plt.grid(axis='y', linestyle='--', alpha=0.7)
    plt.tight_layout()
    plt.show()
