from scipy.stats import chisquare
import pandas as pd
import os

csv_path = "numbers.csv"

if not os.path.exists(csv_path):
    raise FileNotFoundError(f"CSV file not found at: {csv_path}")

# Load the CSV
df = pd.read_csv(csv_path)

# Print the first few rows and column names to debug
print("Columns found:", df.columns.tolist())
print(df.head())

# Try to access the correct column (try by name or fallback to last column)
if "generated number" in df.columns:
    observed = df["generated number"]
else:
    observed = df.iloc[:, -1]  # fallback to last column

# Drop NaNs (if any)
observed = observed.dropna()

# Make sure it's all integers
observed = observed.astype(int)

# Expected frequencies assuming uniform distribution
total = sum(observed)
expected = [total / 10] * 10

# Chi-squared test
chi2_stat, p_value = chisquare(f_obs=observed, f_exp=expected)

print(f"Chi-squared Statistic: {chi2_stat:.2f}")
print(f"P-value: {p_value:.4f}")

if p_value < 0.05:
    print("The digit distribution is statistically *not* uniform (likely not random).")
else:
    print("The digit distribution is statistically uniform (likely random).")
