#!/usr/bin/env bash
set -euo pipefail

# ===== Config =====

BASE_DIR= "path_to_your_project_directory"  # TODO
DATA_DIR="$BASE_DIR/data"
LOG_DIR="$BASE_DIR/logs"

mkdir -p "$DATA_DIR" "$LOG_DIR"

TIMESTAMP=$(date +"%Y%m%d-%H%M%S")
TIMESTAMP_DIR="$DATA_DIR/$TIMESTAMP"
mkdir -p "$TIMESTAMP_DIR"

LOG_FILE="$LOG_DIR/data_collect.log"

# ===== API keys / URLs =====

WEATHER_API_KEY="your_api_key_here"  # TODO

WEATHER_URL="https://api.weatherapi.com/v1/current.json?key=${WEATHER_API_KEY}&q=guernsey&aqi=no"
FLIGHTS_URL="https://data.gg/api/Flights/Arrivals"
SAILINGS_URL="https://data.gg/api/Sailings/Harbour"

# ===== Function to fetch and save data =====

fetch_and_save() {
    local url="$1"
    local name="$2"
    local outfile="$TIMESTAMP_DIR/${name}.json"

    {
        echo "[$(date -Iseconds)] Fetching $name from $url"
        if curl -sS "$url" -o "$outfile"; then
            chmod 0444 "$outfile"
            echo "[$(date -Iseconds)] Saved to $outfile"
        else
            echo "[$(date -Iseconds)] ERROR fetching $name"
        fi
    } >>"$LOG_FILE" 2>&1
}

# ===== Main =====

fetch_and_save "$WEATHER_URL" "weather"
fetch_and_save "$FLIGHTS_URL" "flights"
fetch_and_save "$SAILINGS_URL" "sailings"

echo "[$(date -Iseconds)] Data collection complete" >>"$LOG_FILE"
