#!/usr/bin/env bash
set -euo pipefail

# ===== Config =====

BASE_DIR= "path_to_your_project_directory"  # TODO
OUTPUT_DIR="$BASE_DIR/output"
PLOTS_DIR="$OUTPUT_DIR/plots"
REPORT_MD="$OUTPUT_DIR/report.md"
REPORT_HTML="$OUTPUT_DIR/report.html"
REPORT_PDF="$OUTPUT_DIR/report.pdf"
REPORT_DOCX="$OUTPUT_DIR/report.docx"
OLD_REPORTS_DIR="$OUTPUT_DIR/old_reports"

# ===== Functions =====

generate_markdown_report() {
  echo "# Data Analysis Report" > "$REPORT_MD"
  echo "" >> "$REPORT_MD"

  echo "## Temperature and Humidity Over Time" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "![Temperature and Humidity Over Time](plots/temperature_humidity_over_time.png)" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"

  echo "## Arrivals Over Time" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "![Arrivals Over Time](plots/arrivals_over_time.png)" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat." >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"

  echo "## Arrivals Over Time With Prediction" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "![Arrivals Over Time With Prediction](plots/arrivals_over_time_with_prediction.png)" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur." >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"

  echo "## Popular Origins of Boats and Planes by Region" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "![Popular Origins of Boats and Planes](plots/popular_origins_bar_chart.png)" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "Vivamus vel porttitor nisi. In vehicula lectus ut magna molestie, a vehicula nunc ultricies." >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"

  echo "## Conclusion" >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "Pellentesque facilisis neque non turpis faucibus, a ornare lorem condimentum." >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"
  echo "Ut in suscipit dolor, consectetur ornare lectus. Praesent blandit aliquet felis auctor molestie." >> "$REPORT_MD"
  echo "" >> "$REPORT_MD"

  echo "Report generated at: $(date)" >> "$REPORT_MD"
  echo "Report markdown updated at $REPORT_MD"
}

backup_old_pdf_report() {
  mkdir -p "$OLD_REPORTS_DIR"
  if [[ -f "$REPORT_PDF" ]]; then
    YESTERDAY=$(date -d "yesterday" +%Y%m%d)
    BACKUP_PDF_NAME="report_$YESTERDAY.pdf"
    echo "Backing up existing PDF report to $OLD_REPORTS_DIR/$BACKUP_PDF_NAME"
    mv "$REPORT_PDF" "$OLD_REPORTS_DIR/$BACKUP_PDF_NAME"
  fi
}

generate_html_report() {
  if command -v pandoc >/dev/null 2>&1; then
    pandoc "$REPORT_MD" -o "$REPORT_HTML"
    echo "HTML report generated at $REPORT_HTML"
  else
    echo "Pandoc not found, skipping HTML report generation"
  fi
}

generate_pdf_and_docx_reports() {
  if command -v pandoc >/dev/null 2>&1; then
    cd "$OUTPUT_DIR"
    pandoc "$REPORT_MD" -o "$REPORT_PDF"
    echo "PDF report generated at $REPORT_PDF"
    pandoc "$REPORT_MD" -o "$REPORT_DOCX"
    echo "Word report generated at $REPORT_DOCX"
  else
    echo "Pandoc not found, skipping PDF and Word report generation"
  fi
}

# ===== Main =====

main() {
  generate_markdown_report
  backup_old_pdf_report
  generate_html_report
  generate_pdf_and_docx_reports
}

main "$@"
