import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Main {

    public static int[][] visitedBestWord = new int[5][5];
    public static int visitedNumber = 0;
    public static long searchIterations = 0;
    public static long wordsManipulateIterations = 0;
    public static List<String> impossibleWordsCache = new ArrayList<>();
    public static boolean wasImpossible;
    public static boolean isImpossible;
    public static long startTime = 0;
    public static long endTime = 0;
    public static long tempStartTime = 0;
    public static long tempStopTime = 0;
    public static long mathTimer = 0;
    public static long wordCreationTimer = 0;
    public static long wordFinderTimer = 0;
    public static int DL;
    public static int TL;
    public static int DW;
    public static char DLHit;
    public static char TLHit;
    public static boolean DWHit;
    public static char charAtDLTL;
    public static char charAtDW;
    public static String originalWord;
    public static int originalWordLetter;
    public static String mainInput;
    public static String subBoardAroundDLTL;
    public static String subBoardAroundDW;
    public static int currentEdit;
    public static final int wordcount = 112457;
    public static final int maxEdits = 3;
    public static int tracker = 0;
    public static int[][] direction = new int[2][8];

    public static void main(String[] args) {

        mainInput = getMainUserInput("Type de 25 letters van linksboven naar rechtsonder in 1 woord: ");


        DL = askForInt("Enter the DL position (0 means none): ") - 1;
        TL = askForInt("Enter the TL position (0 means none): ") - 1;
        DW = askForInt("Enter the DW position (0 means none): ") - 1;
        if (DL + TL + 1 >= 0) {
            charAtDLTL = mainInput.charAt(DL + TL + 1);
        }
        if (DW >= 0) {
            charAtDW = mainInput.charAt(DW);
        }

        startTime = System.nanoTime();
        //for (int averageIndex = 0; averageIndex < 10; averageIndex++) {

        for (int edits = 0; edits <= maxEdits; edits++) {
            NEdits(edits);
        }

        //}
        endTime = System.nanoTime();

        System.out.println("---------------------------------------------------------"
                + "\nend of program succesfully reached"
                + "\ndelay: " + ((endTime - startTime)/1000000000) + "." + String.format("%03d", ((endTime - startTime)/1000000)%1000) + " seconds"
                + "\n|- of which spent on creating words: " + (wordCreationTimer/1000000000) + "." + String.format("%03d", ((wordCreationTimer)/1000000)%1000) + " seconds"
                + "\n|-- of which spent on finding words: " + (wordFinderTimer/1000000000) + "." + String.format("%03d", ((wordFinderTimer)/1000000)%1000) + " seconds"
                + "\n|--- of which spent on calculating values: " + (mathTimer/1000000000) + "." + String.format("%03d", ((mathTimer)/1000000)%1000) + " seconds"
                + "\n|---- whatever this is is between you and god: " + (((endTime - startTime)-wordCreationTimer-wordFinderTimer-mathTimer)/1000000000) + "." + String.format("%03d", (((endTime - startTime)-wordCreationTimer-wordFinderTimer-mathTimer)/10000000)%1000) + " seconds"
                + "\nsearch itartions: " + searchIterations
                + "\nwords manipulate itartions: " + wordsManipulateIterations
                + "\n---------------------------------------------------------");
    }

    public static void NEdits(int edits) {
        impossibleWordsCache.clear();
        char[][] board = toBoard(mainInput);
        String filePath = "src/dictionary.txt";
        File file = new File(filePath);
        int bestValue = 0;
        String word = null;
        String bestWord = null;
        String bestWordIteration = null;
        String[] wordsearchIterations;
        tracker = 0;
        currentEdit = edits;

        if (edits != 0) {
            if (!(DL+TL == -2)) {
                subBoardAroundDLTL = createSubBoard(toBoard(mainInput), DL + TL + 1, edits + 1);
            }
            if (!(DW == -1)) {
                subBoardAroundDW = createSubBoard(toBoard(mainInput), DW, edits + 1);
            }
        }

        try {

            Scanner scanner = new Scanner(file);

            while (scanner.hasNextLine()) {
                if (tracker++%2000 == 0) {
                    System.out.print("-");
                }
                wasImpossible = true;
                isImpossible = false;

                word = scanner.nextLine();

                for (String impossibleWord : impossibleWordsCache) {
                    if (word.contains(impossibleWord)) {
                        isImpossible = true;
                        break;
                    }
                }

                if ((word.length() >= edits) && (calculateValueOptimistically(word) > bestValue) && (!isImpossible) && (canBeFormed(word, edits))){

                    tempStartTime = System.nanoTime();
                    wordsearchIterations = generateWordsNOff(word, edits);
                    tempStopTime = System.nanoTime();
                    wordCreationTimer += tempStopTime - tempStartTime;

                    for (String wordIteration:wordsearchIterations){

                        if (canBeFormed(wordIteration, 0)) {
                            originalWord = word;



                            if (isWordPossible(board, wordIteration)) {
                                tempStartTime = System.nanoTime();
                                wasImpossible = false;
                                int tempValue = calculateValue(word);
                                if (tempValue > bestValue) {
                                    bestValue = tempValue;
                                    bestWord = word;
                                    bestWordIteration = wordIteration;
                                    //System.out.printf("Word found: %s %d %nOn the board: %s %n", word, bestValue, wordIteration);
                                    //System.out.printf("searchIterations: %d %n", searchIterations);
                                }
                                tempStopTime = System.nanoTime();
                                mathTimer += tempStopTime - tempStartTime;

                            }
                        }
                    }

                    if(wasImpossible) {
                        impossibleWordsCache.add(word);
                    }

                }

            }

            System.out.printf("%n"
                    + "[%d edits]%n"
                    + "Word found: %s %d %n"
                    + "On the board: %s %n", edits, bestWord, bestValue, bestWordIteration);
            enhancedIsWordPossible(board, bestWordIteration);
            printUsedLetters(visitedBestWord);

            scanner.close();

        } catch (FileNotFoundException e) {
            System.out.println("File not found: " + filePath);
            e.printStackTrace();
        }
    }

    private static char[][] toBoard(String inputWord) {
        if (inputWord.length() != 25) {
            throw new IllegalArgumentException("Input word must be 25 letters long.");
        }

        char[][] charArray = new char[5][5];
        int index = 0;

        for (int i = 0; i < 5; i++) {
            for (int j = 0; j < 5; j++) {
                charArray[i][j] = inputWord.charAt(index);
                index++;
            }
        }

        return charArray;
    }

    private static int askForInt(String prompt) {
        Scanner scanner = new Scanner(System.in);
        System.out.print(prompt);
        return scanner.nextInt();
    }

    private static String getMainUserInput(String prompt) {
        Scanner scanner = new Scanner(System.in);
        System.out.print(prompt);
        return scanner.nextLine();
    }

    private static boolean isWordPossible(char[][] charArray, String word) {
        tempStartTime = System.nanoTime();
        DLHit = '0';
        TLHit = '0';
        originalWordLetter = -1;
        DWHit = false;
        int rows = charArray.length;
        int cols = charArray[0].length;
        boolean[][] visited = new boolean[rows][cols];


        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < cols; j++) {
                if (checkWord(charArray, word, i, j, visited)) {
                    tempStopTime = System.nanoTime();
                    wordFinderTimer += tempStopTime - tempStartTime;
                    return true;
                }
            }
        }
        tempStopTime = System.nanoTime();
        wordFinderTimer += tempStopTime - tempStartTime;
        return false;
    }

    private static boolean checkWord(char[][] charArray, String word, int row, int col, boolean[][] visited) {
        searchIterations ++;

        if (word.isEmpty()) {
            return true;
        }

        int rows = charArray.length;
        int cols = charArray[0].length;

        if (row >= 0 && row < rows && col >= 0 && col < cols && !visited[row][col] &&
                charArray[row][col] == word.charAt(0)) {
            visited[row][col] = true;
            originalWordLetter++;

            if (row * 5 + col == DL) {
                DLHit = originalWord.charAt(originalWordLetter);
            } else if (row * 5 + col == TL) {
                TLHit = originalWord.charAt(originalWordLetter);
            } else if (row * 5 + col == DW) {
                DWHit = true;
            }

            generateDirection(row, col);

            boolean found = checkWord(charArray, word.substring(1), row + direction[0][0], col + direction[0][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[1][0], col + direction[1][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[2][0], col + direction[2][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[3][0], col + direction[3][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[4][0], col + direction[4][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[5][0], col + direction[5][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[6][0], col + direction[6][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[7][0], col + direction[7][1], visited);

            visited[row][col] = false;

            if(!found) {
                originalWordLetter --;
            }

            return found;
        }

        return false;
    }

    private static void generateDirection(int currentNodeRow, int currentNodeCol) {

        int searchNodeRow = 0;
        int searchNodeCol = 0;

        if (!DWHit && !(DW < 0)) {
            searchNodeRow = DW/5;
            searchNodeCol = DW%5;
        } else if ((DLHit == '0' && !(DL < 0)) || (TLHit == '0' && !(TL < 0))) {
            searchNodeRow = (TL + DL + 1)/5;
            searchNodeCol = (TL + DL + 1)%5;
        }

        if (searchNodeCol < currentNodeCol) {
            if (searchNodeRow < currentNodeRow) {
                direction = new int[][] {{-1,-1},{-1,0},{0,-1},{-1,1},{1,-1},{0,1},{1,0},{1,1}};
                return;
            } else if (searchNodeRow > currentNodeRow) {
                direction = new int[][] {{1,-1},{0,-1},{1,0},{-1,-1},{1,1},{-1,0},{0,1},{-1,1}};
                return;
            }
            direction = new int[][] {{0,-1},{-1,-1},{1,-1},{-1,0},{1,0},{1,1},{-1,1},{0,1}};
            return;
        } else if (searchNodeCol == currentNodeCol) {
            if (searchNodeRow < currentNodeRow) {
                direction = new int[][] {{-1,0},{-1,-1},{-1,1},{0,1},{0,-1},{1,-1},{1,1},{1,0}};
                return;
            }
            direction = new int[][] {{1,0},{1,-1},{1,1},{0,1},{0,-1},{-1,-1},{-1,1},{-1,0}};
            return;
        } else {
            if (searchNodeRow < currentNodeRow) {
                direction = new int[][] {{-1,1},{-1,0},{0,1},{-1,-1},{1,1},{0,-1},{1,0},{1,-1}};
                return;
            } else if (searchNodeRow > currentNodeRow) {
                direction = new int[][] {{1,1},{0,1},{1,0},{1,-1},{-1,1},{0,-1},{-1,0},{-1,-1}};
                return;
            }
        }
        direction = new int[][] {{0,1},{-1,1},{1,1},{-1,0},{1,0},{-1,-1},{1,-1},{0,-1}};
        return;
    }

    private static void enhancedIsWordPossible(char[][] charArray, String word) {
        int rows = charArray.length;
        int cols = charArray[0].length;
        boolean[][] visited = new boolean[rows][cols];
        visitedNumber = 0;
        for (int i = 0; i < visitedBestWord.length; i++) {
            for (int j = 0; j < visitedBestWord[i].length; j++) {
                visitedBestWord[i][j] = 0;
            }
        }

        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < cols; j++) {
                if (enhancedCheckWord(charArray, word, i, j, visited)) {
                    return;
                }
            }
        }
    }

    private static boolean enhancedCheckWord(char[][] charArray, String word, int row, int col, boolean[][] visited) {
        searchIterations ++;

        if (word.isEmpty()) {
            return true;
        }

        int rows = charArray.length;
        int cols = charArray[0].length;

        if (row >= 0 && row < rows && col >= 0 && col < cols && !visited[row][col] &&
                charArray[row][col] == word.charAt(0)) {
            visited[row][col] = true;
            visitedNumber ++;
            visitedBestWord[row][col] = visitedNumber;

            generateDirection(row, col);

            boolean found = checkWord(charArray, word.substring(1), row + direction[0][0], col + direction[0][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[1][0], col + direction[1][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[2][0], col + direction[2][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[3][0], col + direction[3][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[4][0], col + direction[4][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[5][0], col + direction[5][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[6][0], col + direction[6][1], visited) ||
                    checkWord(charArray, word.substring(1), row + direction[7][0], col + direction[7][1], visited);


            visited[row][col] = false;
            if (!found) {
                visitedNumber --;
                visitedBestWord[row][col] = 0;
            }

            return found;
        }

        return false;
    }

    private static int calculateValueOptimistically(String word) {

        tempStartTime = System.nanoTime();

        int[] letterValues = {
                1, 4, 5, 3, 1, 5, 3, 4, 1, 7,
                6, 3, 4, 2, 1, 4, 8, 2, 2, 2,
                4, 5, 5, 7, 4, 8
        };

        word = word.toUpperCase();

        int totalValue = 0;
        int bestValue = 0;

        for (int i = 0; i < word.length(); i++) {
            char currentChar = word.charAt(i);

            if (Character.isLetter(currentChar)) {
                int alphabetIndex = currentChar - 'A';

                if (alphabetIndex >= 0 && alphabetIndex < letterValues.length) {
                    totalValue += letterValues[alphabetIndex];
                    if (letterValues[alphabetIndex] > bestValue) {
                        bestValue = letterValues[alphabetIndex];
                    }
                }
            }
        }

        if (DL >= 0) {
            if (checkWordInSubBoard(subBoardAroundDLTL, word.toLowerCase(), charAtDLTL)) {
                totalValue += bestValue;
            }
        }

        if (TL >= 0) {
            if (checkWordInSubBoard(subBoardAroundDLTL, word.toLowerCase(), charAtDLTL)) {
                totalValue += bestValue * 2;
            }
        }

        if (DW >= 0) {
            if (checkWordInSubBoard(subBoardAroundDW, word.toLowerCase(), charAtDW)) {
                totalValue += totalValue;
            }
        }

        if (word.length() > 5) {
            totalValue += 10;
        }

        tempStopTime = System.nanoTime();
        mathTimer += tempStopTime - tempStartTime;

        return totalValue;
    }

    private static int calculateValue(String word) {

        int[] letterValues = {
                1, 4, 5, 3, 1, 5, 3, 4, 1, 7,
                6, 3, 4, 2, 1, 4, 8, 2, 2, 2,
                4, 5, 5, 7, 4, 8
        };

        word = word.toUpperCase();

        int totalValue = 0;

        for (int i = 0; i < word.length(); i++) {
            char currentChar = word.charAt(i);

            if (Character.isLetter(currentChar)) {
                int alphabetIndex = currentChar - 'A';

                if (alphabetIndex >= 0 && alphabetIndex < letterValues.length) {
                    totalValue += letterValues[alphabetIndex];
                }
            }
        }

        if (DL >= 0 && (!(DLHit == '0'))) {
            DLHit = Character.toUpperCase(DLHit);
            int alphabetIndex = DLHit - 'A';
            totalValue += letterValues[alphabetIndex];
        }

        if (TL >= 0 && (!(TLHit == '0'))) {
            TLHit = Character.toUpperCase(TLHit);
            int alphabetIndex = TLHit - 'A';
            totalValue += letterValues[alphabetIndex] * 2;
        }

        if (DWHit) {
            totalValue *= 2;
        }

        if (word.length() > 5) {
            totalValue += 10;
        }

        return totalValue;
    }

    private static void printUsedLetters(int[][] array) {
        for (int i = 0; i < array.length; i++) {
            for (int j = 0; j < array[i].length; j++) {
                System.out.print("[" + array[i][j] + "]");
            }
            System.out.println();
        }
    }

    public static String[] generateWordsNOff(String inputWord, int maxEdits) {
        int wordLength = inputWord.length();
        char[] charArray = inputWord.toCharArray();
        Set<String> resultSet = new HashSet<>();
        String boardString = mainInput;

        Map<Character, Integer> charFrequency = new HashMap<>();
        StringBuilder validChars = new StringBuilder();

        for (char boardChar : boardString.toCharArray()) {
            charFrequency.put(boardChar, charFrequency.getOrDefault(boardChar, 0) + 1);
            if (charFrequency.get(boardChar) <= maxEdits) {
                validChars.append(boardChar);
            }
        }

        generateWordsNOffHelper(charArray, validChars.toString().toCharArray(), 0, wordLength, maxEdits, inputWord, resultSet);

        return resultSet.toArray(new String[0]);
    }

    private static void generateWordsNOffHelper(char[] charArray, char[] validChars, int startIndex, int wordLength, int maxEdits, String inputWord, Set<String> resultSet) {

        if (maxEdits == 0 || !canBeFormed(new String(charArray), maxEdits)) {
            resultSet.add(inputWord);
            return;
        }

        for (int i = startIndex; i < wordLength; i++) {
            for (char boardChar : validChars) {
                wordsManipulateIterations++;
                if (boardChar != charArray[i]) {
                    char originalChar = charArray[i];
                    charArray[i] = boardChar;
                    String generatedWord = new String(charArray);

                    if (!generatedWord.equals(inputWord) && canBeFormed(generatedWord, maxEdits - 1)) {
                        resultSet.add(generatedWord);
                        generateWordsNOffHelper(charArray, validChars, i + 1, wordLength, maxEdits - 1, inputWord, resultSet);
                    }
                    charArray[i] = originalChar;
                }
            }
        }
    }

    public static boolean canBeFormed(String wordIterationCheck, int n) {
        int[] charCount = new int[26];

        for (char c : mainInput.toCharArray()) {
            charCount[c - 'a']++;
        }

        for (char c : wordIterationCheck.toCharArray()) {
            if (charCount[c - 'a'] > 0) {
                charCount[c - 'a']--;
            } else if (n > 0) {
                n--;
            } else {
                return false;
            }
        }

        return true;
    }

    public static String createSubBoard(char[][] inputArray, int position, int range) {
        int arraySize = inputArray.length;
        int row = position / arraySize;
        int col = position % arraySize;

        int startRow = Math.max(0, row - range + 1);
        int endRow = Math.min(arraySize - 1, row + range - 1);
        int startCol = Math.max(0, col - range + 1);
        int endCol = Math.min(arraySize - 1, col + range - 1);

        String resultBoard = "";

        for (int i = startRow; i <= endRow; i++) {
            for (int j = startCol; j <= endCol; j++) {
                resultBoard += inputArray[i][j];
            }
        }

        return resultBoard;
    }

    public static boolean checkWordInSubBoard(String subBoard, String word, char charAt) {

        int matches = 0;

        //if (tracker%100 == 0) {
        //	System.out.println(subBoard + ", " + word + ", " + charAt);
        //}

        if (currentEdit >= 4 || currentEdit == 0) {return true;}

        if (word.charAt(0) == charAt || word.charAt(word.length() - 1) == charAt) {
            return true;
        }

        for (int wordIndex = 0; wordIndex < word.length(); wordIndex ++) {
            for (int boardIndex = 0; boardIndex < subBoard.length(); boardIndex ++) {
                if (word.charAt(wordIndex) == subBoard.charAt(boardIndex)) {
                    matches ++;
                    if (matches == currentEdit + 1) {
                        return true;
                    }
                    break;
                }
            }
        }

        return false;
    }
}
